/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.db.CommandMetaData;
import com.sun.star.wizards.db.DBMetaData;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.db.SQLQueryComposer;
import java.util.ArrayList;
import java.util.HashMap;

public class QueryMetaData
extends CommandMetaData {
    private SQLQueryComposer oSQLQueryComposer = null;
    public String Command;
    private PropertyValue[][] m_aFilterConditions;
    private PropertyValue[][] GroupByFilterConditions = new PropertyValue[0][];
    public int Type = 1;

    public QueryMetaData(XMultiServiceFactory _xMSF) {
        super(_xMSF);
    }

    public void setFilterConditions(PropertyValue[][] _FilterConditions) {
        this.m_aFilterConditions = _FilterConditions;
    }

    public PropertyValue[][] getFilterConditions() {
        if (this.m_aFilterConditions == null) {
            this.m_aFilterConditions = new PropertyValue[0][];
        }
        return this.m_aFilterConditions;
    }

    public void setGroupByFilterConditions(PropertyValue[][] _GroupByFilterConditions) {
        this.GroupByFilterConditions = _GroupByFilterConditions;
    }

    public PropertyValue[][] getGroupByFilterConditions() {
        return this.GroupByFilterConditions;
    }

    public void addSeveralFieldColumns(String[] _FieldNames, String _sCommandName) {
        ArrayList<FieldColumn> oToBeAddedFieldColumns = new ArrayList<FieldColumn>();
        for (int i = 0; i < _FieldNames.length; ++i) {
            FieldColumn oFieldColumn = this.getFieldColumn(_FieldNames[i], _sCommandName);
            if (oFieldColumn != null) continue;
            oToBeAddedFieldColumns.add(new FieldColumn(this, _FieldNames[i], _sCommandName, false));
        }
        if (oToBeAddedFieldColumns.size() > 0) {
            int nOldFieldCount = this.FieldColumns.length;
            FieldColumn[] LocFieldColumns = new FieldColumn[nOldFieldCount + oToBeAddedFieldColumns.size()];
            System.arraycopy(this.FieldColumns, 0, LocFieldColumns, 0, nOldFieldCount);
            for (int i = 0; i < oToBeAddedFieldColumns.size(); ++i) {
                LocFieldColumns[nOldFieldCount + i] = (FieldColumn)oToBeAddedFieldColumns.get(i);
            }
            this.FieldColumns = LocFieldColumns;
        }
    }

    public void reorderFieldColumns(String[] _sDisplayFieldNames) {
        FieldColumn[] LocFieldColumns = new FieldColumn[this.FieldColumns.length];
        for (int i = 0; i < _sDisplayFieldNames.length; ++i) {
            FieldColumn LocFieldColumn;
            LocFieldColumns[i] = LocFieldColumn = this.getFieldColumnByDisplayName(_sDisplayFieldNames[i]);
        }
        System.arraycopy(LocFieldColumns, 0, this.FieldColumns, 0, LocFieldColumns.length);
    }

    public void removeSeveralFieldColumnsByDisplayFieldName(String[] _DisplayFieldNames) {
        ArrayList<FieldColumn> oRemainingFieldColumns = new ArrayList<FieldColumn>();
        for (int n = 0; n < this.FieldColumns.length; ++n) {
            String sDisplayFieldName = this.FieldColumns[n].getDisplayFieldName();
            if (JavaTools.FieldInList(_DisplayFieldNames, sDisplayFieldName) > -1) continue;
            oRemainingFieldColumns.add(this.FieldColumns[n]);
        }
        this.FieldColumns = new FieldColumn[oRemainingFieldColumns.size()];
        oRemainingFieldColumns.toArray(this.FieldColumns);
    }

    public String[] getIncludedCommandNames() {
        ArrayList<String> CommandNamesV = new ArrayList<String>(1);
        for (int i = 0; i < this.FieldColumns.length; ++i) {
            FieldColumn CurQueryField = this.FieldColumns[i];
            String CurCommandName = CurQueryField.getCommandName();
            if (CommandNamesV.contains(CurCommandName)) continue;
            CommandNamesV.add(CurCommandName);
        }
        String[] sIncludedCommandNames = new String[CommandNamesV.size()];
        CommandNamesV.toArray(sIncludedCommandNames);
        return sIncludedCommandNames;
    }

    public static String[] getIncludedCommandNames(String[] _FieldNames) {
        ArrayList<String> CommandNames = new ArrayList<String>(1);
        for (int i = 0; i < _FieldNames.length; ++i) {
            String[] MetaList = JavaTools.ArrayoutofString(_FieldNames[i], ".");
            if (MetaList.length <= 1) continue;
            StringBuilder sb = new StringBuilder(PropertyNames.EMPTY_STRING);
            for (int a = 0; a < MetaList.length - 1; ++a) {
                sb.append(MetaList[a]);
            }
            String CurCommandName = sb.toString();
            if (CommandNames.contains(CurCommandName)) continue;
            CommandNames.add(CurCommandName);
        }
        String[] sIncludedCommandNames = new String[CommandNames.size()];
        CommandNames.toArray(sIncludedCommandNames);
        return sIncludedCommandNames;
    }

    public void initializeFieldTitleSet() {
        try {
            if (this.FieldTitleSet == null) {
                this.FieldTitleSet = new HashMap();
            }
            String[] aCommandNames = this.getIncludedCommandNames();
            for (int i = 0; i < aCommandNames.length; ++i) {
                String sCommandName = aCommandNames[i];
                DBMetaData.CommandObject oTable = this.getTableByName(sCommandName);
                String sTableName = oTable.getName();
                String[] LocFieldNames = oTable.getColumns().getElementNames();
                for (int a = 0; a < LocFieldNames.length; ++a) {
                    String sDisplayFieldName = FieldColumn.composeDisplayFieldName(sTableName, LocFieldNames[a]);
                    if (this.FieldTitleSet.containsKey(sDisplayFieldName)) continue;
                    this.FieldTitleSet.put(sDisplayFieldName, LocFieldNames[a]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public String[] getUniqueAggregateFieldNames() {
        ArrayList<String> UniqueAggregateFieldVector = new ArrayList<String>();
        for (int i = 0; i < this.AggregateFieldNames.length; ++i) {
            if (UniqueAggregateFieldVector.contains(this.AggregateFieldNames[i][0])) continue;
            UniqueAggregateFieldVector.add(this.AggregateFieldNames[i][0]);
        }
        return UniqueAggregateFieldVector.toArray(new String[UniqueAggregateFieldVector.size()]);
    }

    public boolean hasNumericalFields() {
        for (int i = 0; i < this.FieldColumns.length; ++i) {
            if (!this.FieldColumns[i].isNumberFormat()) continue;
            return true;
        }
        return false;
    }

    public int getAggregateIndex(String _DisplayFieldName) {
        int iAggregate = -1;
        if (this.Type == 0) {
            iAggregate = JavaTools.FieldInTable(this.AggregateFieldNames, _DisplayFieldName);
        }
        return iAggregate;
    }

    public SQLQueryComposer getSQLQueryComposer() {
        if (this.oSQLQueryComposer == null) {
            this.oSQLQueryComposer = new SQLQueryComposer(this);
        }
        return this.oSQLQueryComposer;
    }

    public static interface QueryType {
        public static final int SOSUMMARYQUERY = 0;
        public static final int SODETAILQUERY = 1;
    }
}

