/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdb.XCompletedExecution;
import com.sun.star.sdb.XResultSetAccess;
import com.sun.star.sdbc.XResultSet;
import com.sun.star.sdbc.XRow;
import com.sun.star.sdbcx.XColumnsSupplier;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.InvalidQueryException;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.db.QueryMetaData;
import java.util.ArrayList;

public class RecordParser
extends QueryMetaData {
    private XNameAccess xColumns;
    private XRow xResultSetRow;
    private XResultSet ResultSet;
    private XInterface xRowSet;
    private XCompletedExecution xExecute;
    private XComponent xRowSetComponent;
    private XInteractionHandler xInteraction;
    private FieldColumn[] GroupFieldColumns;
    private FieldColumn[] RecordFieldColumns;

    public RecordParser(XMultiServiceFactory _xMSF) {
        super(_xMSF);
        this.getInterfaces();
    }

    public FieldColumn[] getRecordFieldColumns() {
        return this.RecordFieldColumns;
    }

    public void setRecordFieldColumns(FieldColumn[] recordFieldColumns) {
        this.RecordFieldColumns = recordFieldColumns;
    }

    public FieldColumn[] getGroupFieldColumns() {
        return this.GroupFieldColumns;
    }

    public void setGroupFieldColumns(FieldColumn[] groupFieldColumns) {
        this.GroupFieldColumns = groupFieldColumns;
    }

    private void getInterfaces() {
        try {
            this.xRowSet = (XInterface)this.xMSF.createInstance("com.sun.star.sdb.RowSet");
            UnoRuntime.queryInterface(XColumnsSupplier.class, (Object)this.xRowSet);
            this.xRowSetComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.xRowSet);
            this.xExecute = (XCompletedExecution)UnoRuntime.queryInterface(XCompletedExecution.class, (Object)this.xRowSet);
            XInterface oInteraction = (XInterface)this.xMSF.createInstance("com.sun.star.task.InteractionHandler");
            this.xInteraction = (XInteractionHandler)UnoRuntime.queryInterface(XInteractionHandler.class, (Object)oInteraction);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private Object getColumnStringValue(int ColIndex) {
        try {
            String sValue = this.xResultSetRow.getString(ColIndex);
            Type CurType = new Type(String.class);
            Object oAny = AnyConverter.toObject((Type)CurType, (Object)sValue);
            return oAny;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    private Object getColumnDoubleValue(int ColIndex, boolean bisDate) {
        try {
            Double DblValue = bisDate ? Double.valueOf(this.xResultSetRow.getDouble(ColIndex) + (double)super.getNullDateCorrection()) : Double.valueOf(this.xResultSetRow.getDouble(ColIndex));
            if (!this.xResultSetRow.wasNull()) {
                return DblValue;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return Any.VOID;
    }

    private Object getColumnValue(int ColIndex, int iType) {
        Object oAny = Any.VOID;
        switch (iType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 92: {
                oAny = this.getColumnDoubleValue(ColIndex, false);
                break;
            }
            case 91: 
            case 93: {
                oAny = this.getColumnDoubleValue(ColIndex, true);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                oAny = this.getColumnStringValue(ColIndex);
            }
        }
        return oAny;
    }

    public boolean executeCommand(int _nCommandType) throws InvalidQueryException {
        try {
            Helper.setUnoPropertyValue(this.xRowSet, "DataSourceName", this.getDataSourceName());
            Helper.setUnoPropertyValue(this.xRowSet, PropertyNames.ACTIVE_CONNECTION, this.getDBConnection());
            Helper.setUnoPropertyValue(this.xRowSet, PropertyNames.COMMAND, this.Command);
            Helper.setUnoPropertyValue(this.xRowSet, PropertyNames.COMMAND_TYPE, _nCommandType);
            this.xExecute.executeWithCompletion(this.xInteraction);
            XResultSetAccess xResultAccess = (XResultSetAccess)UnoRuntime.queryInterface(XResultSetAccess.class, (Object)this.xRowSet);
            this.ResultSet = xResultAccess.createResultSet();
            this.xResultSetRow = (XRow)UnoRuntime.queryInterface(XRow.class, (Object)this.ResultSet);
            XColumnsSupplier xDBCols = (XColumnsSupplier)UnoRuntime.queryInterface(XColumnsSupplier.class, (Object)this.ResultSet);
            this.xColumns = xDBCols.getColumns();
            this.setCommandType(_nCommandType);
            return true;
        }
        catch (Exception exception) {
            throw new InvalidQueryException(this.xMSF, this.Command, exception);
        }
    }

    public boolean getFields(String[] _sFieldNames, boolean binitializeDBColumns) {
        try {
            if (binitializeDBColumns) {
                this.initializeFieldColumns(_sFieldNames, this.xColumns);
            }
            String[] AllQueryFieldNames = this.xColumns.getElementNames();
            for (int i = 0; i < this.FieldColumns.length; ++i) {
                int nColIndex;
                String sFieldName = this.FieldColumns[i].getFieldName();
                this.FieldColumns[i].ColIndex = nColIndex = JavaTools.FieldInList(AllQueryFieldNames, sFieldName) + 1;
                if (nColIndex != -1) continue;
                throw new InvalidQueryException(this.xMSF, this.Command);
            }
            this.GroupFieldColumns = this.getFieldColumnList(this.getGroupFieldNames());
            this.RecordFieldColumns = this.getFieldColumnList(this.getRecordFieldNames());
            return true;
        }
        catch (InvalidQueryException queryexception) {
            queryexception.printStackTrace(System.err);
            return false;
        }
    }

    private FieldColumn[] getFieldColumnList(String[] _FieldNames) {
        FieldColumn[] LocFieldColumns = new FieldColumn[_FieldNames.length];
        for (int i = 0; i < _FieldNames.length; ++i) {
            LocFieldColumns[i] = super.getFieldColumnByFieldName(_FieldNames[i]);
        }
        return LocFieldColumns;
    }

    public Object getGroupColumnValue(int ColIndex) {
        FieldColumn CurDBFieldColumn = this.GroupFieldColumns[ColIndex];
        return this.getColumnValue(CurDBFieldColumn.ColIndex, CurDBFieldColumn.getFieldType());
    }

    public boolean getcurrentRecordData(ArrayList<Object[]> DataVector) {
        Object[] RecordValueArray = new Object[this.RecordFieldColumns.length];
        for (int i = 0; i < this.RecordFieldColumns.length; ++i) {
            FieldColumn CurDBFieldColumn = this.RecordFieldColumns[i];
            RecordValueArray[i] = this.getColumnValue(CurDBFieldColumn.ColIndex, CurDBFieldColumn.getFieldType());
        }
        DataVector.add(RecordValueArray);
        return true;
    }

    public XResultSet getResultSet() {
        return this.ResultSet;
    }

    @Override
    public void dispose() {
        if (this.xRowSetComponent != null) {
            this.xRowSetComponent.dispose();
        }
        super.dispose();
    }
}

