/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.text;

import com.sun.star.awt.Size;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyState;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.document.XDocumentPropertiesSupplier;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XLoadable;
import com.sun.star.frame.XModule;
import com.sun.star.frame.XStorable;
import com.sun.star.frame.XTerminateListener;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.XStyle;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.task.XStatusIndicator;
import com.sun.star.task.XStatusIndicatorFactory;
import com.sun.star.text.XSimpleText;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.XModifiable;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.document.OfficeDocument;
import com.sun.star.wizards.text.TextFieldHandler;
import com.sun.star.wizards.text.ViewHandler;

public class TextDocument {
    public XComponent xComponent;
    protected XTextDocument xTextDocument;
    protected XStatusIndicator xProgressBar;
    public XFrame xFrame;
    public XText xText;
    protected XMultiServiceFactory xMSFDoc;
    public XMultiServiceFactory xMSF;
    public XWindowPeer xWindowPeer;

    public TextDocument(XMultiServiceFactory xMSF, String _sPreviewURL, boolean bShowStatusIndicator, XTerminateListener listener) {
        this.xMSF = xMSF;
        this.xFrame = OfficeDocument.createNewFrame(xMSF, listener);
        this.xTextDocument = this.loadAsPreview(_sPreviewURL, true);
        this.xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.xTextDocument);
        if (bShowStatusIndicator) {
            this.showStatusIndicator();
        }
        this.init();
    }

    public TextDocument(XMultiServiceFactory xMSF, ModuleIdentifier _moduleIdentifier, boolean bShowStatusIndicator) {
        this.xMSF = xMSF;
        try {
            this.xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)xMSF.createInstance("com.sun.star.text.TextDocument"));
            XLoadable xLoadable = (XLoadable)UnoRuntime.queryInterface(XLoadable.class, (Object)this.xTextDocument);
            xLoadable.initNew();
            XModule xModule = (XModule)UnoRuntime.queryInterface(XModule.class, (Object)this.xTextDocument);
            xModule.setIdentifier(_moduleIdentifier.getIdentifier());
            XDesktop xDesktop = Desktop.getDesktop(xMSF);
            XComponentLoader xLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)xDesktop);
            PropertyValue[] loadArgs = new PropertyValue[]{new PropertyValue("Model", -1, (Object)this.xTextDocument, PropertyState.DIRECT_VALUE)};
            xLoader.loadComponentFromURL("private:object", "_blank", 0, loadArgs);
            this.xFrame = this.xTextDocument.getCurrentController().getFrame();
            this.xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.xTextDocument);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (bShowStatusIndicator) {
            this.showStatusIndicator();
        }
        this.init();
    }

    public TextDocument(XMultiServiceFactory xMSF, XTextDocument _textDocument, boolean bshowStatusIndicator) {
        this.xMSF = xMSF;
        this.xFrame = _textDocument.getCurrentController().getFrame();
        this.xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)_textDocument);
        this.xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)this.xComponent);
        if (bshowStatusIndicator) {
            XStatusIndicatorFactory xStatusIndicatorFactory = (XStatusIndicatorFactory)UnoRuntime.queryInterface(XStatusIndicatorFactory.class, (Object)this.xFrame);
            this.xProgressBar = xStatusIndicatorFactory.createStatusIndicator();
            this.xProgressBar.start(PropertyNames.EMPTY_STRING, 100);
            this.xProgressBar.setValue(5);
        }
        this.xWindowPeer = (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.xFrame.getComponentWindow());
        this.xMSFDoc = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDocument);
        UnoRuntime.queryInterface(XNumberFormatsSupplier.class, (Object)this.xTextDocument);
        XDocumentPropertiesSupplier xDocPropsSuppl = (XDocumentPropertiesSupplier)UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)this.xTextDocument);
        xDocPropsSuppl.getDocumentProperties();
        Helper.getUnoStructValue(this.xComponent, "CharLocale");
        this.xText = this.xTextDocument.getText();
    }

    private void init() {
        this.xWindowPeer = (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.xFrame.getComponentWindow());
        this.xMSFDoc = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDocument);
        UnoRuntime.queryInterface(XNumberFormatsSupplier.class, (Object)this.xTextDocument);
        XDocumentPropertiesSupplier xDocPropsSuppl = (XDocumentPropertiesSupplier)UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)this.xTextDocument);
        xDocPropsSuppl.getDocumentProperties();
        Helper.getUnoStructValue(this.xComponent, "CharLocale");
        UnoRuntime.queryInterface(XStorable.class, (Object)this.xTextDocument);
        this.xText = this.xTextDocument.getText();
    }

    private void showStatusIndicator() {
        XStatusIndicatorFactory xStatusIndicatorFactory = (XStatusIndicatorFactory)UnoRuntime.queryInterface(XStatusIndicatorFactory.class, (Object)this.xFrame);
        this.xProgressBar = xStatusIndicatorFactory.createStatusIndicator();
        this.xProgressBar.start(PropertyNames.EMPTY_STRING, 100);
        this.xProgressBar.setValue(5);
    }

    private XTextDocument loadAsPreview(String sDefaultTemplate, boolean asTemplate) {
        PropertyValue[] loadValues = new PropertyValue[3];
        loadValues[0] = new PropertyValue();
        loadValues[0].Name = PropertyNames.READ_ONLY;
        loadValues[0].Value = Boolean.TRUE;
        loadValues[1] = new PropertyValue();
        loadValues[1].Name = "AsTemplate";
        loadValues[1].Value = asTemplate ? Boolean.TRUE : Boolean.FALSE;
        loadValues[2] = new PropertyValue();
        loadValues[2].Name = "Preview";
        loadValues[2].Value = Boolean.TRUE;
        if (this.xTextDocument != null) {
            try {
                XModifiable xModi = (XModifiable)UnoRuntime.queryInterface(XModifiable.class, (Object)this.xTextDocument);
                xModi.setModified(false);
            }
            catch (PropertyVetoException e1) {
                e1.printStackTrace(System.err);
            }
        }
        Object oDoc = OfficeDocument.load((XInterface)this.xFrame, sDefaultTemplate, "_self", loadValues);
        this.xTextDocument = (XTextDocument)oDoc;
        this.getPageSize();
        this.xMSFDoc = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xTextDocument);
        ViewHandler myViewHandler = new ViewHandler(this.xTextDocument);
        try {
            myViewHandler.setViewSetting("ZoomType", (short)2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TextFieldHandler myFieldHandler = new TextFieldHandler(this.xMSF, this.xTextDocument);
        myFieldHandler.updateDocInfoFields();
        return this.xTextDocument;
    }

    public XTextDocument getTextDocument() {
        return this.xTextDocument;
    }

    public XStatusIndicator getProgressBar() {
        return this.xProgressBar;
    }

    public XMultiServiceFactory getMSFDoc() {
        return this.xMSFDoc;
    }

    private Size getPageSize() {
        try {
            XStyleFamiliesSupplier xStyleFamiliesSupplier = (XStyleFamiliesSupplier)UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)this.xTextDocument);
            XNameAccess xNameAccess = null;
            xNameAccess = xStyleFamiliesSupplier.getStyleFamilies();
            XNameContainer xPageStyleCollection = null;
            xPageStyleCollection = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)xNameAccess.getByName("PageStyles"));
            XStyle xPageStyle = (XStyle)UnoRuntime.queryInterface(XStyle.class, (Object)xPageStyleCollection.getByName("First Page"));
            return (Size)Helper.getUnoPropertyValue(xPageStyle, "Size");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static XTextCursor createTextCursor(Object oCursorContainer) {
        XSimpleText xText = (XSimpleText)UnoRuntime.queryInterface(XSimpleText.class, (Object)oCursorContainer);
        return xText.createTextCursor();
    }

    public void unlockallControllers() {
        while (this.xTextDocument.hasControllersLocked()) {
            this.xTextDocument.unlockControllers();
        }
    }

    public static class ModuleIdentifier {
        private final String m_identifier;

        private final String getIdentifier() {
            return this.m_identifier;
        }

        public ModuleIdentifier(String _identifier) {
            this.m_identifier = _identifier;
        }
    }
}

